--[[---------------------------------------------------------------------------
	Chocolatier Two High Scores dialog
	Copyright (c) 2007 Big Splash Games, LLC. All Rights Reserved.
--]]---------------------------------------------------------------------------

-- Look to submit a new high score
if GetNumUsers() > 0 and not gSim then Simulator:LoadGame() end
if gSim then gSim:LogScore() end

local localOnly = bsgCheckConfig("local")
local anonymous = bsgCheckConfig("anonymous")

local HighlightColor = YellowColor

local globalhighscoreinfo = "globalhighscoreinfo"
if bsgCheckConfig("anonymous") then
	globalhighscoreinfo = "anonymous_highscoreinfo"
end

-------------------------------------------------------------------------------

local hugeH = kThirty
local largeH = kTwentyFour
local standardH = bsgFontHeight(standardFont)
--local kScoreH = kEighteen
local kScoreH = kSeventeen

local ScoreFont = { standardFontName, kScoreH, BlackColor }
local smallFont = { standardFontName, kFifteen, BlackColor }
local largeFont = { standardFontName, largeH, BlackColor }
local hugeFont = { standardFontName, hugeH, BlackColor }

-------------------------------------------------------------------------------

local h=bsgFontHeight(dialogFont)

-------------------------------------------------------------------------------

local function DoLocalView() ViewLocal(0) end
local function DoGlobalView() ViewGlobal(0) end
local function DoNextCategory() NextCategory() end
local function DoPreviousCategory() PreviousCategory() end
local function DoNextMode() NextMode() end
local function DoPreviousMode() PreviousMode() end

local function DoScrollUp() ScrollUp() end
local function DoScrollDown() ScrollDown() end

local function DoSubmitScore() DisplayDialog { "ui/hiscoresubmit.lua" } end
local function DoSubmitMedals() DisplayDialog { "ui/hiscoresubmit.lua", medalsOnly=true } end

-------------------------------------------------------------------------------

local function ScoreList(y)
	local scores = {}
	for i=1,10 do
		table.insert(scores, Group {
			Text { x=0,y=y,w=34,h=kScoreH,
					name = tostring(i), label = tostring(989+i)..".",
					font = ScoreFont, flags = kHAlignRight + kVAlignCenter,
			},
			
			Bitmap { x=34,y=y+(kScoreH-16)/2, image="image/p1icon", name="p1_"..tostring(i) },

			Text { x=51,y=y,w=kMax,h=kScoreH,
					name = "name"..tostring(i), label = "#name",
					font = ScoreFont, flags = kHAlignLeft + kVAlignCenter,
			},
			
			Text { x=51,y=y,w=kMax-1,h=kScoreH,
					name = "score"..tostring(i), label = "#$99,999,999",
					font = ScoreFont, flags = kHAlignRight + kVAlignCenter,
			},
		})
		y = y + kScoreH + 1
	end
	return Group(scores)
end

-------------------------------------------------------------------------------

MakeDialog
{
	name="highscores",
	Frame
	{
		x=20,y=20,w=ui.screenWidth-40,h=ui.screenHeight-40,color=DialogColor,
		ornament="",
		
		AppendStyle { font=dialogFont },
		
		HighScores
		{
			x=0,y=0,w=kMax,h=kMax,

			Text { name="title", x=kCenter,y=0,w=400,h=hugeH, label="highscores_title", font=hugeFont },

			Text { name="mode", x=kCenter,y=hugeH,w=200,h=hugeH, label="mode", font=hugeFont },
			Button { name="nextmode", x=500,y=hugeH, label="next", command=DoNextMode,
					graphics=LeftButtonGraphics, hflip=true, scale=hugeH/64 },
			Button { name="prevmode", x=260-hugeH,y=hugeH, label="prev", command=DoPreviousMode,
					graphics=LeftButtonGraphics, scale=hugeH/64 },
			Text { x=0,y=0,w=kMax,h=h, name="server_status", label="", flags=kVAlignCenter+kHAlignRight },
			
			Frame
			{
				name="scores", x=20,y=85,w=720,h=300, fit=false, ornament="",color=DialogColor,

				Text { name="type", x=0,y=0,w=kMax,h=largeH, label="type", font=largeFont },
				Text { name="category", x=kCenter,y=largeH,w=140,h=20, label="" },
				Button { name="next_category", x=470,y=largeH, label="next", command=DoNextCategory,
					graphics=LeftButtonGraphics, hflip=true, scale=standardH/64, },
				Button { name="prev_category", x=250-standardH,y=largeH, label="next", command=DoPreviousCategory,
					graphics=LeftButtonGraphics, scale=standardH/64, },
				Rectangle { name="highlight", x=0,y=kMax,w=kMax,h=kScoreH, color=HighlightColor },
				
				Button { name="scrollup", x=700,y=largeH+largeH-20, command=DoScrollUp,
					graphics=LeftButtonGraphics, rotate=true, scale=20/64, },
				ScoreList(largeH + largeH),
				Button { name="scrolldown", x=700,y=largeH+largeH+10*kScoreH, command=DoScrollDown,
					graphics=LeftButtonGraphics, rotate=true, hflip=true, scale=20/64, },
			},
			
			Text { name="globalinfo", x=0,y=405,w=kMax,h=20, label=globalhighscoreinfo, font={ standardFontName, kSixteen, DefaultColor }, },
			Button { name="privacy", graphics={}, command=PrivacyPolicy },
			
			TextButton { name="back", x=10,y=500, label="back", close=true },
			TextButton { name="view_local", x=580,y=500, label="viewlocal", command=DoLocalView },
			TextButton { name="view_global", x=580,y=500, label="viewglobal", command=DoGlobalView },
			
			Text { name="eligible", x=kCenter,y=450,w=kMax,h=20, label="eligible", },

--			Text { name="submitresult", x=kCenter,y=430,w=kMax,h=20, label="", },
			Text { x=0,y=430,w=kMax,h=20, name="server_status", label="", flags=kVAlignCenter+kHAlignCenter },

			Button { name="moreinfo", graphics={}, command=function() DisplayDialog { "ui/hiscoreinfo.lua" } end, },
			TextButton { name="submit_score", x=kCenter,y=470, label="submit_score", command=DoSubmitScore },
			TextButton { name="submit_medals", x=kCenter,y=470, label="submit_medals", command=DoSubmitMedals },
--			Text { name="eligibleasterisk", x=kCenter,y=525,w=400,h=kMax, label="eligibleasterisk", font=smallFont, flags=kVAlignTop+kHAlignCenter },
		},
	},
}

DoLocalView()
